<?php

namespace Database\Seeders;

use App\Enums\SystemCode;
use DateTimeZone;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class SystemSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('systems')->insert([
            'code' => SystemCode::BIZ_X_POS,
            'name' => 'POS',
            'url' => '#',
            'effective_date_time' => Carbon::yesterday(),
            'expiry_date_time' => Carbon::now()->addDays(1000),
            'created_by'=> 1,
            'updated_by'=> 1,
            'created_at'=> Carbon::now(),
            'updated_at'=> Carbon::now(),
        ]);
    }
}
