<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;

use Illuminate\Support\Facades\DB;

class MainNavigationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('main_navigations')->insert([
            'id' => 1,
            'label' => 'Dashboard',
            'path' => '/dashboard',
            'icon' => 'Dashboard',
            'order' => 1,
            'is_active' => 1
        ]);

        DB::table('main_navigations')->insert([
            'id' => 2,
            'label' => 'Invoice',
            'path' => '/sales-sms',
            'icon' => 'ShoppingCart',
            'order' => 2,
            'is_active' => 1
        ]);
        DB::table('main_navigations')->insert([
            'id' => 17,
            'label' => 'List of Invoice',
            'path' => '/list-of-invoice',
            'icon' => 'FormatListNumbered',
            'order' => 3,
            'is_active' => 1
        ]);
        DB::table('main_navigations')->insert([
            'id' => 18,
            'label' => 'List of Saved Invoice',
            'path' => '/list-of-saved-invoice',
            'icon' => 'FormatListNumbered',
            'order' => 4,
            'is_active' => 1
        ]);

        DB::table('main_navigations')->insert([
            'id' => 3,
            'label' => 'Stock',
            'path' => '/stock',
            'icon' => 'Store',
            'order' => 5,
            'is_active' => 1
        ]);

        DB::table('main_navigations')->insert([
            'id' => 4,
            'label' => 'Item & Services',
            'path' => '/item',
            'icon' => 'TextSnippet',
            'order' => 6,
            'is_active' => 1
        ]);

        DB::table('main_navigations')->insert([
            'id' => 5,
            'label' => 'Customers',
            'path' => '/customers',
            'icon' => 'PeopleAlt',
            'order' => 7,
            'is_active' => 1
        ]);

        DB::table('main_navigations')->insert([
            'id' => 6,
            'label' => 'Cheque Receipts',
            'path' => '/cheque',
            'icon' => 'LocalAtm',
            'order' => 8,
            'is_active' => 1
        ]);

        DB::table('main_navigations')->insert([
            'id' => 7,
            'label' => 'RTN Cheque Pay',
            'path' => '/chequePayment',
            'icon' => 'Replay',
            'order' => 9,
            'is_active' => 1
        ]);

        DB::table('main_navigations')->insert([
            'id' => 8,
            'label' => 'Suppliers',
            'path' => '/suppliers',
            'icon' => 'SupervisorAccount',
            'order' => 10,
            'is_active' => 1
        ]);

        DB::table('main_navigations')->insert([
            'id' => 9,
            'label' => 'Cheque Vouchers',
            'path' => '/cheque-vouchers',
            'icon' => 'LocalAtm',
            'order' => 11,
            'is_active' => 1
        ]);


        DB::table('main_navigations')->insert([
            'id' => 10,
            'label' => 'Sales Rep',
            'path' => '/salesRep',
            'icon' => 'SupervisedUserCircle',
            'order' => 11,
            'is_active' => 1
        ]);

        DB::table('main_navigations')->insert([
            'id' => 11,
            'label' => 'Reversal',
            'path' => '/reversal',
            'icon' => 'Replay',
            'order' => 13,
            'is_active' => 1
        ]);

        DB::table('main_navigations')->insert([
            'id' => 12,
            'label' => 'Reports',
            'path' => '/reports',
            'icon' => 'BarChart',
            'order' => 14,
            'is_active' => 1
        ]);

        DB::table('main_navigations')->insert([
            'id' => 13,
            'label' => 'Barcode',
            'path' => '/barcode',
            'icon' => 'CropFree',
            'order' => 15,
            'is_active' => 1
        ]);

        DB::table('main_navigations')->insert([
            'id' => 14,
            'label' => 'Expenses',
            'path' => '/expenses',
            'icon' => 'ViewCompact',
            'order' => 16,
            'is_active' => 1
        ]);

        // DB::table('main_navigations')->insert([
        //     'id' => 15,
        //     'label' => 'Accounts',
        //     'path' => '/accounts',
        //     'icon' => 'Calculate',
        //     'order' => 17,
        //     'is_active' => 1
        // ]);

        DB::table('main_navigations')->insert([
            'id' => 16,
            'label' => 'Stock Freeze',
            'path' => '/stock-freeze',
            'icon' => 'Dashboard',
            'order' => 18,
            'is_active' => 1
        ]);
        // DB::table('main_navigations')->insert([
        //     'id' => 2,
        //     'label' => 'Invoice',
        //     'path' => '/salesForSms',
        //     'icon' => 'ShoppingCart',
        //     'order' => 2,
        //     'is_active' => 1
        // ]);
    }
}
