<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class LevelOneNavigationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('level_one_navigations')->insert([
            'id' => 1,
            'label' => 'GRN',
            'path' => '/grn',
            'icon' => 'Note',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 3,
            'order' => 1,
            'is_active' => 1
        ]);

        DB::table('level_one_navigations')->insert([
            'id' => 2,
            'label' => 'Mature Stock',
            'path' => '/matureStock',
            'icon' => 'CheckBox',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 3,
            'order' => 2,
            'is_active' => 1
        ]);

        DB::table('level_one_navigations')->insert([
            'id' => 3,
            'label' => 'Transfer',
            'path' => '/stock-transfer',
            'icon' => 'SwapHoriz',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 3,
            'order' => 3,
            'is_active' => 1
        ]);

        DB::table('level_one_navigations')->insert([
            'id' => 4,
            'label' => 'Stock In',
            'path' => '/stock-in',
            'icon' => 'LabelImportant',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 3,
            'order' => 4,
            'is_active' => 1
        ]);

        DB::table('level_one_navigations')->insert([
            'id' => 5,
            'label' => 'Stock Dashboard',
            'path' => '/stock-dashboard',
            'icon' => 'Inventory',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 3,
            'order' => 5,
            'is_active' => 1
        ]);

        DB::table('level_one_navigations')->insert([
            'id' => 38,
            'label' => 'Expiry Dashboard',
            'path' => '/expiry-dashboard',
            'icon' => 'CalendarMonth',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 3,
            'order' => 6,
            'is_active' => 1
        ]);

        DB::table('level_one_navigations')->insert([
            'id' => 6,
            'label' => 'Sales Order',
            'path' => '/sales-order',
            'icon' => 'AddShoppingCart',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 3,
            'order' => 7,
            'is_active' => 1
        ]);

        DB::table('level_one_navigations')->insert([
            'id' => 7,
            'label' => 'Sales Quotation',
            'path' => '/sales-quotation',
            'icon' => 'ListAltSharp',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 3,
            'order' => 8,
            'is_active' => 1
        ]);
        DB::table('level_one_navigations')->insert([
            'id' => 8,
            'label' => 'Stock Issue',
            'path' => '/stock-issue',
            'icon' => 'TurnRight',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 3,
            'order' => 9,
            'is_active' => 1
        ]);
        DB::table('level_one_navigations')->insert([
            'id' => 9,
            'label' => 'Item & Service',
            'path' => '/item-master',
            'icon' => 'TextSnippet',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 4,
            'order' => 10,
            'is_active' => 1
        ]);
        DB::table('level_one_navigations')->insert([
            'id' => 10,
            'label' => 'Category',
            'path' => '/item-category',
            'icon' => 'Category',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 4,
            'order' => 11,
            'is_active' => 1
        ]);
        DB::table('level_one_navigations')->insert([
            'id' => 11,
            'label' => 'Brand',
            'path' => '/item-brand',
            'icon' => 'Apps',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 4,
            'order' => 12,
            'is_active' => 1
        ]);

        DB::table('level_one_navigations')->insert([
            'id' => 12,
            'label' => 'Bin Location',
            'path' => '/item-bin',
            'icon' => 'AllInbox',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 4,
            'order' => 13,
            'is_active' => 1
        ]);

        DB::table('level_one_navigations')->insert([
            'id' => 13,
            'label' => 'Colour',
            'path' => '/item-colour',
            'icon' => 'ColorLens',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 4,
            'order' => 14,
            'is_active' => 1
        ]);
        DB::table('level_one_navigations')->insert([
            'id' => 37,
            'label' => 'Unit',
            'path' => '/item-unit',
            'icon' => 'FilterList',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 4,
            'order' => 37,
            'is_active' => 1
        ]);
        DB::table('level_one_navigations')->insert([
            'id' => 14,
            'label' => 'Size',
            'path' => '/item-size',
            'icon' => 'FormatSize',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 4,
            'order' => 15,
            'is_active' => 1
        ]);
        DB::table('level_one_navigations')->insert([
            'id' => 15,
            'label' => 'Customer',
            'path' => '/customer',
            'icon' => 'PeopleAlt',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 5,
            'order' => 16,
            'is_active' => 1
        ]);
        DB::table('level_one_navigations')->insert([
            'id' => 16,
            'label' => 'Payment Receipt',
            'path' => '/payment-receipt',
            'icon' => 'Receipt',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 5,
            'order' => 17,
            'is_active' => 1
        ]);
        DB::table('level_one_navigations')->insert([
            'id' => 17,
            'label' => 'Sales Return',
            'path' => '/sales-return',
            'icon' => 'KeyboardReturn',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 5,
            'order' => 18,
            'is_active' => 1
        ]);
        DB::table('level_one_navigations')->insert([
            'id' => 18,
            'label' => 'Third party Cheque',
            'path' => '/third-party-cheque',
            'icon' => 'LocalAtm',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 6,
            'order' => 19,
            'is_active' => 1
        ]);
        DB::table('level_one_navigations')->insert([
            'id' => 19,
            'label' => 'Cheques in Hand',
            'path' => '/cheques',
            'icon' => 'LocalAtm',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 6,
            'order' => 20,
            'is_active' => 1
        ]);
        DB::table('level_one_navigations')->insert([
            'id' => 20,
            'label' => 'Cheques in Deposit',
            'path' => '/cheques-process',
            'icon' => 'LocalAtm',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 6,
            'order' => 21,
            'is_active' => 1
        ]);
        DB::table('level_one_navigations')->insert([
            'id' => 21,
            'label' => 'Realized Cheques',
            'path' => '/cheque-realized',
            'icon' => 'Check',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 6,
            'order' => 22,
            'is_active' => 1
        ]);
        DB::table('level_one_navigations')->insert([
            'id' => 22,
            'label' => 'Returned Cheques',
            'path' => '/returned-cheque',
            'icon' => 'LocalAtm',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 6,
            'order' => 23,
            'is_active' => 1
        ]);
        DB::table('level_one_navigations')->insert([
            'id' => 23,
            'label' => 'Cheque Receipt',
            'path' => '/chequePayment',
            'icon' => 'PriceCheck',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 7,
            'order' => 24,
            'is_active' => 1
        ]);
        DB::table('level_one_navigations')->insert([
            'id' => 24,
            'label' => 'Suppliers',
            'path' => '/suppliers',
            'icon' => 'SupervisorAccount',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 8,
            'order' => 25,
            'is_active' => 1
        ]);
        DB::table('level_one_navigations')->insert([
            'id' => 25,
            'label' => 'Payment Vouchers',
            'path' => '/payment-vouchers',
            'icon' => 'Payment',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 8,
            'order' => 26,
            'is_active' => 1
        ]);
        DB::table('level_one_navigations')->insert([
            'id' => 26,
            'label' => 'Purchase Return',
            'path' => '/purchase-return',
            'icon' => 'MoneyOff',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 8,
            'order' => 27,
            'is_active' => 1
        ]);
        DB::table('level_one_navigations')->insert([
            'id' => 27,
            'label' => 'Cheques in hand',
            'path' => '/cheque-vouchers',
            'icon' => 'LocalAtm',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 9,
            'order' => 28,
            'is_active' => 1
        ]);
        DB::table('level_one_navigations')->insert([
            'id' => 28,
            'label' => 'Cheques in Process',
            'path' => '/cheque-vouchers-process',
            'icon' => 'LocalAtm',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 9,
            'order' => 29,
            'is_active' => 1
        ]);
        DB::table('level_one_navigations')->insert([
            'id' => 29,
            'label' => 'Returned Cheques',
            'path' => '/returned-cheque-vouchers',
            'icon' => 'LocalAtm',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 9,
            'order' => 30,
            'is_active' => 1
        ]);
        DB::table('level_one_navigations')->insert([
            'id' => 30,
            'label' => 'Sales Rep',
            'path' => '/salesRep',
            'icon' => 'SupervisedUserCircle',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 10,
            'order' => 31,
            'is_active' => 1
        ]);
        DB::table('level_one_navigations')->insert([
            'id' => 31,
            'label' => 'Route',
            'path' => '/route',
            'icon' => 'SwapVerticalCircle',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 10,
            'order' => 32,
            'is_active' => 1
        ]);
        DB::table('level_one_navigations')->insert([
            'id' => 32,
            'label' => 'Expenses',
            'path' => '/expenses',
            'icon' => 'ViewCompact',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 14,
            'order' => 33,
            'is_active' => 1
        ]);
        DB::table('level_one_navigations')->insert([
            'id' => 33,
            'label' => 'Expenses Categories',
            'path' => '/expanses-category',
            'icon' => 'ListAlt',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 14,
            'order' => 34,
            'is_active' => 1
        ]);
        DB::table('level_one_navigations')->insert([
            'id' => 34,
            'label' => 'Debit/Credit',
            'path' => '/credit-and-debit',
            'icon' => 'CalculateOutlined',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 15,
            'order' => 35,
            'is_active' => 1
        ]);
        DB::table('level_one_navigations')->insert([
            'id' => 35,
            'label' => 'Journal Type',
            'path' => '/journal-types',
            'icon' => 'CalculateOutlined',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 15,
            'order' => 36,
            'is_active' => 1
        ]);
        DB::table('level_one_navigations')->insert([
            'id' => 36,
            'label' => 'General Ledger',
            'path' => '/general-ledger',
            'icon' => 'AccountBalanceOutlined',
            'props' => '{"color": "red"}',
            'main_navigation_id' => 15,
            'order' => 37,
            'is_active' => 1
        ]);



    }
}
