<?php

use App\Enums\MultiPurposeStatus;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('invoice_temps', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->bigInteger('stock_location_code')->nullable();
            $table->bigInteger('series_code')->nullable();
            $table->string('invoice_number')->nullable();
            $table->bigInteger('invoice_source_code')->nullable();
            $table->dateTime('date_time')->nullable();
            $table->bigInteger('customer_code')->nullable();
            $table->bigInteger('sales_quotation_code')->nullable();
            $table->bigInteger('sales_order_code')->nullable();
            $table->decimal('sub_total_amount', 18, 2)->nullable();
            $table->decimal('discount_amount', 10, 2)->nullable();
            $table->decimal('discount_percentage', 10, 2)->nullable();
            $table->decimal('discount_total', 10, 2)->nullable();
            $table->decimal('bill_discount', 10, 2)->nullable();
            $table->decimal('total_amount', 18, 2)->nullable();
            $table->integer('paid_status')->nullable();//(PaymentStatus::PAYMENT_NOT_DONE);
            $table->integer('status')->default(MultiPurposeStatus::ACTIVE);
            $table->string('phone_2')->nullable();
            $table->string('remarks')->nullable();
            $table->integer('prints')->default(1);
            // $table->boolean('bill_header')->default(1);
            $table->integer('billing_price')->nullable();
            $table->boolean('is_locked')->nullable();
            $table->boolean('is_active')->default(1);
            $table->boolean('is_sales_page')->default(0);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('invoice_temps');
    }
};
