<?php

use App\Enums\MultiPurposeStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSupOnlineRtrnChequePaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sup_online_rtrn_cheque_payments', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->bigInteger('cheque_voucher_code')->nullable();
            $table->bigInteger('mode_of_payment_code')->nullable();
            $table->bigInteger('acc_ledger_type_code')->nullable();
            $table->decimal('amount', 50, 2)->nullable();
            $table->dateTime('date_time')->nullable();
            $table->bigInteger('bank_code')->nullable();
            $table->string('transfer_id')->nullable();
            $table->date('transfer_date')->nullable();
            $table->integer('status')->default(MultiPurposeStatus::ACTIVE);
            $table->boolean('is_active')->default(MultiPurposeStatus::ACTIVE);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();

            $table->foreign("mode_of_payment_code")->references("code")->on("sup_cheq_rtrn_mode_of_pays")->onDelete("cascade");

            $table->foreign('cheque_voucher_code')->references('code')->on('sup_cheq_return_vouchers')->onDelete("cascade");
         
            $table->foreign("bank_code")->references("code")->on("banks")->onDelete("cascade");
            
            $table->foreign("acc_ledger_type_code")->references("code")->on("acc_ledger_types")->onDelete("cascade");
       
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sup_online_rtrn_cheque_payments');
    }
}
