<?php

use App\Enums\MultiPurposeStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSupCheqReturnVouchersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sup_cheq_return_vouchers', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->bigInteger('stock_location_code')->nullable();
            $table->bigInteger('supplier_code')->nullable();
            $table->decimal('total_amount', 10, 2)->nullable();//Stores the total received
            $table->decimal('settled_amount', 10, 2)->nullable();//Stores the total settled
            $table->decimal('over_payment', 10, 2)->nullable();//Stores the over payment at that time
            $table->string('remarks')->nullable();
            $table->dateTime('payment_date_time')->nullable();
            $table->integer('status')->default(MultiPurposeStatus::ACTIVE);
            $table->boolean('is_active')->default(MultiPurposeStatus::ACTIVE);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();

            $table->foreign('supplier_code')->references('code')->on('suppliers')->onDelete("cascade");
      });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sup_cheq_return_vouchers');
    }
}
