<?php

use App\Enums\ChequeStatusCode;
use App\Enums\MultiPurposeStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateChequesMoveToBanksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cheques_move_to_banks', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->bigInteger('cheque_payment_code')->nullable();
            $table->bigInteger('acc_ledger_type_code')->nullable();
            $table->integer('status')->default(ChequeStatusCode::CHEQUE_IN_HAND);
            $table->boolean('is_active')->default(MultiPurposeStatus::ACTIVE);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();

            $table->foreign("cheque_payment_code")->references("code")->on("cheque_payments")->onDelete("cascade");

            $table->foreign("acc_ledger_type_code")->references("code")->on("acc_ledger_types")->onDelete("cascade");

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cheques_move_to_banks');
    }
}
