<?php

use App\Enums\MultiPurposeStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSupplierThirdPartyChequesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('supplier_third_party_cheques', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->bigInteger('voucher_code')->nullable();
            $table->bigInteger('mode_of_payment_code')->nullable();
            $table->bigInteger('cheque_payment_code')->nullable();
            $table->bigInteger('supplier_code')->nullable();
            $table->decimal('amount', 50, 2)->nullable();
            $table->dateTime('date_time')->nullable();
            $table->string('remarks')->nullable();
            $table->integer('status')->default(MultiPurposeStatus::ACTIVE);
            $table->boolean('is_active')->default(MultiPurposeStatus::ACTIVE);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();

            
            $table->foreign("supplier_code")-> references("code")-> on("suppliers")-> onDelete("cascade");
            
            $table->foreign("mode_of_payment_code")->references("code")->on("supplier_mode_of_payments")->onDelete("cascade");
            
            $table->foreign("voucher_code")->references("code")->on("payment_vouchers")->onDelete("cascade");
            
            $table->foreign("cheque_payment_code")-> references("code")-> on("cheque_payments")-> onDelete("cascade");
          
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('supplier_third_party_cheques');
    }
}
