<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLevelOneNavigationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('level_one_navigations', function (Blueprint $table) {
            $table->id();
            $table->string('label')->nullable();
            $table->string('path')->nullable();
            $table->string('icon')->nullable();
            $table->string('props')->nullable();
            $table->integer('order')->nullable();
            $table->bigInteger('main_navigation_id')->unsigned();


            $table->boolean('is_active')->default(1);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();

            $table->foreign('main_navigation_id')->references('id')->on('main_navigations')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('level_one_navigations');
    }
}
