<?php

use App\Enums\MultiPurposeStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateExpenseModeOfPaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('expense_mode_of_payments', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->bigInteger('expense_code')->nullable();
            $table->bigInteger('payment_type_code')->nullable();
            $table->decimal('amount', 10, 2)->nullable();
            $table->integer('status')->default(MultiPurposeStatus::ACTIVE);
            $table->boolean('is_active')->default(MultiPurposeStatus::ACTIVE);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();

            $table->foreign('expense_code')->references('code')->on('expenses')->onDelete("cascade");
            
            $table->foreign('payment_type_code')->references('code')->on('payment_types')->onDelete("cascade");
       
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('expense_mode_of_payments');
    }
}
