<?php

use App\Enums\MultiPurposeStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateExpenseCardPaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('expense_card_payments', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->bigInteger('expense_code')->nullable();
            $table->bigInteger('mode_of_payment_code')->nullable();
            $table->bigInteger('acc_ledger_type_code')->nullable();
            $table->decimal('amount', 50, 2)->nullable();
            $table->dateTime('date_time')->nullable();
            $table->string('card_number')->nullable();
            $table->bigInteger('bank_code')->nullable();
            $table->string('remarks')->nullable();
            $table->integer('status')->default(MultiPurposeStatus::ACTIVE);
            $table->boolean('is_active')->default(MultiPurposeStatus::ACTIVE);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();

            $table->foreign("bank_code")->references("code")->on("banks")->onDelete("cascade");
            
            $table->foreign("mode_of_payment_code")->references("code")->on("expense_mode_of_payments")->onDelete("cascade");
           
            $table->foreign('expense_code')->references('code')->on('expenses')->onDelete("cascade");
         
            $table->foreign("acc_ledger_type_code")->references("code")->on("acc_ledger_types")->onDelete("cascade");

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('expense_card_payments');
    }
}
