<?php

use App\Enums\MultiPurposeStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOnlineTransferPaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('online_transfer_payments', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->bigInteger('receipt_code')->nullable();
            $table->bigInteger('mode_of_payment_code')->nullable();
            $table->bigInteger('customer_code')->nullable();
            $table->bigInteger('acc_ledger_type_code')->nullable();
            $table->bigInteger('bank_code')->nullable();
            $table->string('transfer_id')->nullable();
            $table->decimal('amount',50,2)->nullable();
            $table->dateTime('date_time')->nullable();
            $table->string('remarks')->nullable();
            $table->date('transfer_date')->nullable();
            $table->integer('status')->default(MultiPurposeStatus::ACTIVE);
            $table->boolean('is_active')->default(MultiPurposeStatus::ACTIVE);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();

            $table->foreign("bank_code")->references("code")->on("banks")->onDelete("cascade");
            
            $table->foreign("mode_of_payment_code")->references("code")->on("mode_of_payments")->onDelete("cascade");

            $table->foreign("customer_code")->references("code")->on("customers")->onDelete("cascade");
   
            $table->foreign("acc_ledger_type_code")->references("code")->on("acc_ledger_types")->onDelete("cascade");
           
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('online_transfer_payments');
    }
}
