<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAccJournalTypesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('acc_journal_types', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->string('name')->nullable();
            $table->bigInteger('acc_ledger_type_from_code')->nullable();
            $table->integer('entry_type_from')->nullable();
            $table->integer('transaction_mode_from')->nullable();
            $table->bigInteger('acc_ledger_type_to_code')->nullable();
            $table->integer('entry_type_to')->nullable();
            $table->integer('transaction_mode_to')->nullable();
            $table->boolean('is_active')->default(1);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();

            $table->foreign("acc_ledger_type_from_code")->references("code")->on("acc_ledger_types")->onDelete("cascade");
            
            $table->foreign("acc_ledger_type_to_code")->references("code")->on("acc_ledger_types")->onDelete("cascade");

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('acc_journal_types');
    }
}
