<?php

use App\Enums\MultiPurposeStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAccClosingBalancesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('acc_closing_balances', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->date('ledger_date');
            $table->bigInteger('stock_location_code')->nullable();
            $table->bigInteger('acc_ledger_type_code');
            $table->decimal('cash_amount', 18, 2)->nullable();
            $table->decimal('cheque_amount', 18, 2)->nullable();
            $table->boolean('status')->default(MultiPurposeStatus::ACTIVE);
            $table->boolean('is_active')->default(1);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();
            
            $table->foreign("acc_ledger_type_code")->references("code")->on("ledger_types")->onDelete("cascade");

        });

        
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('acc_closing_balances');
    }
}
