<?php

use App\Enums\MultiPurposeStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAccGeneralLedgersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('acc_general_ledgers', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->bigInteger('source_code')->nullable();
            $table->decimal('amount',50,2)->nullable();
            $table->string('entry_type')->nullable();
            $table->string('transaction_type')->default(0);
            $table->bigInteger('acc_closing_balance_code');
            $table->boolean('status')->default(MultiPurposeStatus::ACTIVE);
            $table->boolean('is_active')->default(1);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();

            $table->foreign("acc_closing_balance_code")->references("code")->on("acc_closing_balances")->onDelete("cascade");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('acc_general_ledgers');

    }
}
