<?php

use App\Enums\MultiPurposeStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCusCheqRtrnChequePaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cus_cheq_rtrn_cheque_payments', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->bigInteger('cheque_receipt_code')->nullable();
            $table->bigInteger('mode_of_payment_code')->nullable();
            $table->decimal('amount', 50, 2)->nullable();
            $table->dateTime('date_time')->nullable();
            $table->string('number')->nullable();
            $table->bigInteger('bank_code')->nullable();
            $table->bigInteger('branch_code')->nullable();
            $table->date('deposit_date')->nullable();
            $table->string('remarks')->nullable();
            $table->integer('status')->default(MultiPurposeStatus::ACTIVE);
            $table->boolean('is_active')->default(1);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();

            $table->foreign("mode_of_payment_code")->references("code")->on("cheq_rtrn_mode_of_payments")->onDelete("cascade");

            $table->foreign('cheque_receipt_code')->references('code')->on('cus_cheq_return_receipts')->onDelete("cascade");
         
            $table->foreign("bank_code")->references("code")->on("banks")->onDelete("cascade");

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cus_cheq_rtrn_cheque_payments');
    }
}
