<?php

use App\Enums\MultiPurposeStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCusCheqRtrnCashPaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cus_cheq_rtrn_cash_payments', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->bigInteger('cheque_receipt_code')->nullable();
            $table->bigInteger('mode_of_payment_code')->nullable();
            $table->decimal('amount', 50, 2)->nullable();
            $table->integer('status')->default(MultiPurposeStatus::ACTIVE);
            $table->dateTime('date_time')->nullable();
            $table->boolean('is_active')->default(1);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();

            $table->foreign("mode_of_payment_code")->references("code")->on("cheq_rtrn_mode_of_payments")->onDelete("cascade");

            $table->foreign('cheque_receipt_code')->references('code')->on('cus_cheq_return_receipts')->onDelete("cascade");
         
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cus_cheq_rtrn_cash_payments');
    }
}
