<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use App\Enums\MultiPurposeStatus;
use Illuminate\Support\Facades\Schema;

class CreateCheqPayCustCheqReceiptsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cheq_pay_cust_cheq_receipts', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->bigInteger('cheque_receipt_code')->nullable();
            $table->bigInteger('cheque_paym_code')->nullable();
            $table->decimal('cheque_total', 50, 2)->nullable();
            $table->decimal('paid_amount', 50, 2)->nullable();
            $table->decimal('outstanding', 50, 2)->nullable();
            $table->integer('status')->default(MultiPurposeStatus::ACTIVE);
            $table->boolean('is_active')->default(MultiPurposeStatus::ACTIVE);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();

            $table->foreign('cheque_receipt_code')->references('code')->on('cus_cheq_return_receipts')->onDelete("cascade");
            
            $table->foreign('cheque_paym_code')->references('code')->on('cheque_payments')->onDelete("cascade");

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cheq_pay_cust_cheq_receipts');
    }
}
