<?php

use App\Enums\MultiPurposeStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCheqRtrnModeOfPaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cheq_rtrn_mode_of_payments', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->bigInteger('cheque_receipt_code')->nullable();
            $table->bigInteger('payment_type_code')->nullable();
            $table->decimal('amount', 10, 2)->nullable();
            $table->integer('status')->default(MultiPurposeStatus::ACTIVE);
            $table->boolean('is_active')->default(MultiPurposeStatus::ACTIVE);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();
           
            $table->foreign('cheque_receipt_code')->references('code')->on('cus_cheq_return_receipts')->onDelete("cascade");
           
            $table->foreign('payment_type_code')->references('code')->on('payment_types')->onDelete("cascade");
       
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cheq_rtrn_mode_of_payments');
    }
}
