<?php

use App\Enums\MultiPurposeStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInvoiceExtsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('invoice_exts', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->string('invoice_code')->nullable();
            $table->bigInteger('vehicle_master_code')->nullable();
            $table->decimal('odo_reading', 10, 2)->nullable();
            $table->string('next_service_km')->nullable();
            $table->date('next_service_date')->nullable();
            //$table->decimal('due_amount', 10, 2)->nullable();
            $table->boolean('is_active')->default(1);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();

            $table->foreign("invoice_code")->references("code")->on("invoices")->onDelete("cascade");
            
            $table->foreign("vehicle_master_code")->references("code")->on("vehicle_masters")->onDelete("cascade");

        });
    }


    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('invoice_exts');
    }
}
