<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInvoiceServicePackagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('invoice_service_packages', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->bigInteger('service_package_code')->nullable();
            $table->bigInteger('invoice_code')->nullable();
            $table->decimal('invoice_total', 50, 2)->nullable();
            $table->decimal('paid_amount', 50, 2)->nullable();
            $table->boolean('status')->default(1);
            $table->boolean('is_active')->default(1);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();

            $table->foreign("service_package_code")->references("code")->on("service_packages")->onDelete("cascade");
            
            $table->foreign("invoice_code")->references("code")->on("invoices")->onDelete("cascade");

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('invoice_service_packages');
    }
}
