<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStockHistoryTempsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    /**
     *Name:Fathima Sajana
     *Date:2023.01.05
     *Logic: this table for using when store the quotation or order , at the same time store this table too
     * @return void
     */
    public function up()
    {
        Schema::create('stock_history_temps', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->bigInteger('item_code')->nullable();
            $table->bigInteger('source_code')->nullable();
            $table->bigInteger('stock_code')->nullable();
            $table->integer('source')->nullable();
            $table->decimal('wholesale_price', 10, 2)->nullable();
            $table->decimal('retail_price', 10, 2)->nullable();
            $table->decimal('dealer_price', 10, 2)->nullable();
            $table->decimal('least_price', 10, 2)->nullable();
            $table->decimal('cost_price', 10, 2)->nullable();
            $table->decimal('quantity', 10, 2)->default(0);
            $table->decimal('remaining_quantity', 10, 2)->nullable();
            $table->decimal('unit_sold_price', 10, 2)->nullable();
            $table->decimal('sub_total_amount', 50, 2)->nullable();
            $table->decimal('discount_amount', 15, 2)->nullable();
            $table->decimal('discount_percentage', 15, 2)->nullable();
            $table->decimal('discount_total', 15, 2)->nullable();
            $table->decimal('total_amount', 50, 2)->nullable();
            $table->decimal('warranty_periods', 10, 2)->nullable();
            $table->decimal('warranty_due_date', 10, 2)->nullable();
            $table->date('expiry_date')->nullable();
            $table->boolean('is_active')->default(1);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();

            $table->foreign("item_code")->references("code")->on("item_masters")->onDelete("cascade");


            $table->foreign("stock_code")->references("code")->on("stock")->onDelete("cascade");

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('stock_history_temps');
    }
}
