<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStockHistoryExtsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */    
    /**
     *Name:Fathima Sajana
     *Date:2023.01.05(for comment)
     *Logic: this table for using , qutation or order has pack size / piece (like quantity) stroing this table with 
     *stock_history table
     * @return void
     */
    public function up()
    {
        Schema::create('stock_history_exts', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->bigInteger('stock_history_code')->nullable();
            $table->decimal('pack_size', 10, 2)->nullable();
            $table->integer('boxes')->nullable();
            $table->integer('loos_quantity')->nullable();
            $table->boolean('is_active')->default(1);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();

            $table->foreign("stock_history_code")->references("code")->on("stock_histories")->onDelete("cascade");

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('stock_history_exts');
    }
}
