<?php

use App\Enums\MultiPurposeStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class GrnPaymentVouchers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('grn_payment_vouchers', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->bigInteger('payment_voucher_code')->nullable();
            $table->bigInteger('grn_code')->nullable();
            $table->decimal('grn_total', 50, 2)->nullable();
            $table->decimal('paid_amount', 50, 2)->nullable();
            $table->decimal('outstanding', 50, 2)->nullable();
            $table->string('remarks')->nullable();
            $table->integer('status')->default(MultiPurposeStatus::ACTIVE);
            $table->dateTime('date_time')->nullable();
            $table->boolean('is_active')->default(MultiPurposeStatus::ACTIVE);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();

            $table->foreign("payment_voucher_code")->references("code")->on("payment_vouchers")->onDelete("cascade");

            $table->foreign("grn_code")->references("code")->on("grns")->onDelete("cascade");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('grn_payment_vouchers');

    }
}
