<?php

use App\Enums\MultiPurposeStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePurchaseReturnsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('purchase_returns', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->bigInteger('stock_location_code')->nullable();
            $table->bigInteger('supplier_code')->nullable();
            $table->bigInteger('grn_code')->nullable();
            $table->decimal('total_amount', 12, 2)->nullable();
            $table->string('remarks')->nullable();
            $table->string('return_type')->nullable();
            $table->boolean('paid_status')->default(0);
            $table->dateTime('return_date_time')->nullable();
            $table->boolean('is_active')->default(1);
            $table->integer('status')->default(MultiPurposeStatus::ACTIVE);
            $table->boolean('is_freeze')->default(0);
            $table->dateTime('freeze_time')->nullable();
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();

            $table->foreign("supplier_code")->references("code")->on("suppliers")->onDelete("cascade");

            $table->foreign("grn_code")->references("code")->on("grns")->onDelete("cascade");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('purchase_returns');
    }
}
