<?php

use App\Enums\MultiPurposeStatus;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateStockIssuesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('stock_issues', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->bigInteger('reference_code')->nullable();
            $table->bigInteger('destination_code')->nullable();
            $table->bigInteger('stock_issue_type_code')->nullable();
            $table->bigInteger('stock_location_code')->nullable();
            $table->string('remarks')->nullable();
            $table->decimal('total',50,2)->nullable();
            $table->integer('status')->default(MultiPurposeStatus::ACTIVE);
            $table->boolean('is_active')->default(1);
            $table->boolean('is_department')->default(0);
            $table->boolean('is_locked')->default(0);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();

            $table->foreign('destination_code')->references('code')->on('customers')-> onDelete("cascade");
            $table->foreign('destination_code')->references('code')->on('departments')-> onDelete("cascade");

            $table->foreign('stock_issue_type_code')->references('code')->on('stock_issue_types')-> onDelete("cascade");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('stock_issues');
    }
}
