<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStockTransfersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('stock_transfers', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->bigInteger('stock_location_code_from')->nullable();
            $table->bigInteger('stock_location_code_to')->nullable();
            $table->dateTime('transfer_date_time')->nullable();
            $table->string('remarks')->nullable();
            $table->boolean('is_active')->default(1);
            $table->boolean('is_locked')->default(0);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();
            $table->foreign('stock_location_code_from')->references('code')->on('stock_locations')-> onDelete("cascade");
            $table->foreign('stock_location_code_to')->references('code')->on('stock_locations')-> onDelete("cascade");

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('stock_transfers');
    }
}
