<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Enums\MultiPurposeStatus;

class CreateCashPaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cash_payments', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->bigInteger('receipt_code')->nullable();
            $table->bigInteger('mode_of_payment_code')->nullable();
            $table->bigInteger('customer_code')->nullable();
            $table->decimal('amount', 50, 2)->nullable();
            $table->dateTime('date_time')->nullable();
            $table->string('remarks')->nullable();
            $table->integer('status')->default(MultiPurposeStatus::ACTIVE);
            $table->boolean('is_active')->default(1);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();

            $table->foreign("mode_of_payment_code")->references("code")->on("mode_of_payments")->onDelete("cascade");
           
            $table->foreign("receipt_code")->references("code")->on("payment_receipts")->onDelete("cascade");
         
            $table->foreign("customer_code")->references("code")->on("customers")->onDelete("cascade");
         


        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cash_payments');
    }
}
