<?php

use App\Enums\MultiPurposeStatus;
use App\Enums\ChequeStatusCode;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateChequePaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cheque_payments', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->bigInteger('stock_location_code')->nullable();
            $table->bigInteger('receipt_code')->nullable();
            $table->string('number')->nullable();
            $table->bigInteger('bank_code')->nullable();
            $table->bigInteger('branch_code')->nullable();
            $table->bigInteger('mode_of_payment_code')->nullable();
            $table->bigInteger('customer_code')->nullable();
            $table->bigInteger('acc_ledger_type_code')->nullable();
            $table->decimal('amount', 50, 2)->nullable();
            $table->decimal('paid_amount', 50, 2)->default(0);
            $table->integer('paid_status')->nullable();//(PaymentStatus::PAYMENT_NOT_DONE);
            $table->integer('status')->default(ChequeStatusCode::CHEQUE_IN_HAND);
            $table->dateTime('date_time')->nullable();
            $table->date('deposit_date')->nullable();
            $table->string('remarks')->nullable();
            $table->boolean('is_active')->default(MultiPurposeStatus::ACTIVE);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();

            $table->foreign("mode_of_payment_code")->references("code")->on("mode_of_payments")->onDelete("cascade");

            $table->foreign("bank_code")->references("code")->on("banks")->onDelete("cascade");

            $table->foreign("branch_code")->references("code")->on("bank_branches")->onDelete("cascade");

            $table->foreign('customer_code')->references('code')->on('customers')->onDelete("cascade");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cheque_payments');
    }
}
