<?php

use App\Enums\MultiPurposeStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInvoicePaymentReceiptsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('invoice_payment_receipts', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->bigInteger('payment_receipt_code')->nullable();
            $table->bigInteger('invoice_code')->nullable();
            $table->decimal('invoice_total', 50, 2)->nullable();
            $table->decimal('pay_off', 18, 2)->nullable();
            $table->decimal('paid_amount', 50, 2)->nullable();
            $table->decimal('outstanding', 50, 2)->nullable();
            $table->integer('status')->default(MultiPurposeStatus::ACTIVE);
            $table->dateTime('date_time')->nullable();
            $table->boolean('is_active')->default(MultiPurposeStatus::ACTIVE);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();

            $table->foreign("payment_receipt_code")->references("code")->on("payment_receipts")->onDelete("cascade");

            $table->foreign("invoice_code")->references("code")->on("invoices")->onDelete("cascade");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('invoice_payment_receipts');
    }
}
