<?php

use App\Enums\MultiPurposeStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePaymentReceiptsTable extends Migration
{
    /**
     * Run the migrations.
     * Author : Suhail Jamaldeen
     * Date : 2022.12.02
     * Version : 2
     * Logic : Store the payment receipts
     * @return void
     */
    public function up()
    {
        Schema::create('payment_receipts', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->bigInteger('stock_location_code')->nullable();
            $table->bigInteger('customer_code')->nullable();
            $table->decimal('total_amount', 10, 2)->nullable();//Stores the total received
            $table->decimal('settled_amount', 10, 2)->nullable();//Stores the total settled
            $table->decimal('over_payment', 10, 2)->nullable();//Stores the over payment at that time
            $table->decimal('cheque_return', 10, 2)->nullable();
            $table->string('remarks')->nullable();
            $table->dateTime('payment_date_time')->nullable();
            $table->integer('status')->default(MultiPurposeStatus::ACTIVE);
            $table->boolean('is_active')->default(MultiPurposeStatus::ACTIVE);
            $table->boolean('is_locked')->default(0);
            $table->boolean('is_sales_page')->default(0);
            $table->boolean('is_pay_off_only')->default(0);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();


            $table->foreign('customer_code')->references('code')->on('customers')->onDelete("cascade");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payment_receipts');
    }
}
