<?php

use App\Enums\MultiPurposeStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSalesReturnsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sales_returns', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->bigInteger('stock_location_code')->nullable();
            $table->bigInteger('customer_code')->nullable();
            $table->bigInteger('invoice_code')->nullable();
            $table->decimal('sub_total_amount', 50, 2)->nullable();
            $table->decimal('discount_amount', 50, 2)->nullable();
            $table->decimal('total_amount', 50, 2)->nullable();
            $table->string('remarks')->nullable();
            $table->string('return_type')->nullable();
            $table->boolean('paid_status')->default(0);
            $table->dateTime('return_date_time')->nullable();
            $table->integer('status')->default(MultiPurposeStatus::ACTIVE);
            $table->boolean('is_freeze')->default(0);
            $table->dateTime('freeze_time')->nullable();
            $table->boolean('is_active')->default(1);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();

            $table->timestamps();

            $table->foreign("customer_code")->references("code")->on("customers")->onDelete("cascade");

            $table->foreign("invoice_code")->references("code")->on("invoices")->onDelete("cascade");

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sales_returns');
    }
}
