<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateExpensePaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('expense_payments', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->bigInteger('expense_code')->nullable();
            $table->bigInteger('payment_type_code')->nullable();
            $table->bigInteger('bank_code')->nullable();
            $table->decimal('amount',50,2)->nullable();
            $table->date('payment_date')->nullable();
            $table->date('cheque_date')->nullable();
            $table->string('cheque_number')->nullable();
            $table->string('ref_number')->nullable();
            $table->boolean('is_active')->default(1);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();

            $table->
            foreign("payment_type_code")->
            references("code")->
            on("payment_types")->
            onDelete("cascade");

            $table->
            foreign("expense_code")->
            references("code")->
            on("expenses")->
            onDelete("cascade");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('expense_payments');
    }
}
