<?php

use App\Enums\MultiPurposeStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateExpensesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('expenses', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->bigInteger('stock_location_code')->nullable();
            $table->bigInteger('expense_type_code')->nullable();
            $table->bigInteger('expense_category_code')->nullable();
            // $table->bigInteger('ledger_type_code')->nullable();
            // $table->bigInteger("bank_code")->nullable();
            // $table->bigInteger("payment_type_code")->nullable();
            // $table->date('deposite_date')->nullable();
            // $table->date('cheque_date')->nullable();
            // $table->string('cheque_number')->nullable();
            // $table->string('ref_number')->nullable();
            // $table->string('card_number')->nullable();
            $table->decimal('total_amount',50,2)->nullable();
            $table->dateTime('date_time')->nullable();
            $table->string('description')->nullable();
            $table->boolean('status')->default(MultiPurposeStatus::ACTIVE);
            $table->boolean('is_active')->default(1);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();

            $table->foreign("expense_type_code")->references("code")->on("expense_types")->onDelete("cascade");
           
            $table->foreign("stock_location_code")->references("code")->on("stock_locations")->onDelete("cascade");

            $table->foreign("expense_category_code")->references("code")->on("expense_categories")->onDelete("cascade");

            //$table->foreign("bank_code")->references("code")->on("banks")->onDelete("cascade");

            //$table->foreign("payment_type_code")->references("code")->on("payment_types")->onDelete("cascade");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('expenses');
    }
}
