<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStocksTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('stocks', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->bigInteger('item_code');
            $table->bigInteger('stock_location_code')->nullable();
            $table->bigInteger('grn_code')->nullable();
            $table->string('batch')->nullable();
            $table->decimal('remaining_quantity', 10, 2)->nullable();
            $table->decimal('order_quantity', 10, 2)->default(0);
            $table->decimal('wholesale_price', 10, 2)->nullable();
            $table->decimal('retail_price', 10, 2)->nullable();
            $table->decimal('dealer_price', 10, 2)->nullable();
            $table->decimal('least_price', 10, 2)->nullable();
            $table->decimal('cost_price', 10, 2)->nullable();
            $table->decimal('discount_cost_price', 10, 2)->nullable();
            $table->decimal('discount_price', 10, 2)->nullable();
            $table->decimal('discount', 10, 2)->nullable();
            $table->integer('status')->default(0);
            $table->integer('boxes')->nullable();
            $table->integer('loos_quantity')->nullable();
            $table->date('expiry_date')->nullable();
            $table->boolean('is_freeze')->default(0);
            $table->boolean('is_active')->default(1);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();

            $table->
                foreign("item_code")->
                references("code")->
                on("item_masters")->
                onDelete("cascade");

            $table->foreign("stock_location_code")
                ->references("code")
                ->on("stock_locations")
                ->onDelete("cascade");


            $table->foreign("grn_code")
                ->references("code")
                ->on("grns")
                ->onDelete("cascade");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('stocks');
    }
}