<?php
use App\Enums\PaymentStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Enums\MultiPurposeStatus;

class CreateInvoicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->bigInteger('stock_location_code')->nullable();
            $table->bigInteger('series_code')->nullable();
            $table->string('invoice_number')->nullable();
            $table->bigInteger('invoice_source_code')->nullable();
            $table->dateTime('date_time')->nullable();
            $table->bigInteger('customer_code')->nullable();
            $table->bigInteger('sales_quotation_code')->nullable();
            $table->bigInteger('sales_order_code')->nullable();
            $table->decimal('sub_total_amount', 18, 2)->nullable();
            $table->decimal('discount_amount', 10, 2)->nullable();
            $table->decimal('discount_percentage', 10, 2)->nullable();
            $table->decimal('discount_total', 10, 2)->nullable();
            $table->decimal('bill_discount', 10, 2)->nullable();
            $table->decimal('pay_off', 18, 2)->nullable();
            $table->decimal('total_amount', 18, 2)->nullable();
            $table->decimal('paid_amount', 18, 2)->nullable();
            $table->integer('paid_status')->nullable();//(PaymentStatus::PAYMENT_NOT_DONE);
            $table->integer('status')->default(MultiPurposeStatus::ACTIVE);
            $table->boolean('is_freeze')->default(0);
            $table->dateTime('freeze_time')->nullable();
            $table->decimal('received_amount', 18, 2)->nullable();
            $table->string('phone_2')->nullable();
            $table->string('remarks')->nullable();
            $table->integer('prints')->default(1);
            $table->integer('billing_price')->nullable();
            $table->boolean('is_locked')->nullable();
            $table->boolean('is_active')->default(1);
            $table->boolean('is_sales_page')->default(0);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();

            $table->foreign("customer_code")->references("code")->on("customers")->onDelete("cascade");

            $table->foreign("series_code")->references("code")->on("series")->onDelete("cascade");

            $table->foreign("sales_order_code")->references("code")->on("sales_orders")->onDelete("cascade");

            $table->foreign("invoice_source_code")->references("code")->on("invoice_sources")->onDelete("cascade");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('invoices');
    }
}
