<?php

use App\Enums\MultiPurposeStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSalesOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sales_orders', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->bigInteger('customer_code')->nullable();
            $table->bigInteger('stock_location_code')->nullable();
//          $table->bigInteger('rep_code')->nullable();
            $table->decimal('sub_total_amount', 18, 2)->nullable();
            $table->decimal('discount_amount', 10, 2)->nullable();
            $table->decimal('discount_percentage', 10, 2)->nullable();
            $table->decimal('order_discount', 10, 2)->nullable();
            $table->decimal('total_amount', 18, 2)->nullable();
            $table->string('remarks')->nullable();
            $table->timestamp('order_date')->nullable();
            $table->integer('status')->default(MultiPurposeStatus::ACTIVE);
            $table->boolean('is_active')->default(1);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();

            $table->foreign('customer_code')->references('code')->on('customers')-> onDelete("cascade");

            // $table->foreign('rep_code')->references('code')->on('sales_reps')-> onDelete("cascade");


        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sales_orders');
    }
}
