<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVehicleMastersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('vehicle_masters', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->bigInteger('brand_code')->nullable();
            $table->bigInteger('type_code')->nullable();
            $table->bigInteger('customer_code')->nullable();
            $table->string('description')->nullable();
            $table->string('vehicle_number')->nullable();
            $table->string('service_km')->nullable();
            $table->string('service_period')->nullable();
            $table->boolean('is_active')->default(1);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();

            $table->foreign("brand_code")->references("code")->on("vehicle_brands")->onDelete("cascade");
            $table->foreign("type_code")->references("code")->on("vehicle_types")->onDelete("cascade");
            $table->foreign("customer_code")->references("code")->on("customers")->onDelete("cascade");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vehicle_masters');
    }
}