<?php

use App\Enums\PaymentStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use App\Enums\MultiPurposeStatus;

class CreateGrnsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('grns', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->bigInteger('stock_location_code')->nullable();
            $table->bigInteger('supplier_code');
            $table->string('invoice_code')->nullable();//invoice number.. from invoice
            $table->date('invoice_date')->nullable();
            $table->date('grn_date')->nullable();
            $table->decimal('sub_total_amount',18,2)->nullable();
            $table->decimal('discount_amount', 10, 2)->nullable();
            $table->decimal('discount_percentage', 10, 2)->nullable();
            $table->decimal('grn_discount',12,2)->nullable();
            $table->decimal('total_amount',18,2)->nullable();
            $table->decimal('paid_amount', 18, 2)->nullable();
            $table->string('remarks')->nullable();
            $table->integer('prints')->default(1);
            $table->boolean('paid_status')->nullable(PaymentStatus::PAYMENT_NOT_DONE);
            $table->boolean('status')->default(MultiPurposeStatus::ACTIVE);
            $table->boolean('is_freeze')->default(0);
            $table->dateTime('freeze_time')->nullable();
            $table->boolean('is_locked')->default(0);
            $table->boolean('is_active')->default(1);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();

            $table->foreign("supplier_code")-> references("code")-> on("suppliers")-> onDelete("cascade");

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('grns');
    }
}
