<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSupplierAddressesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('supplier_addresses', function (Blueprint $table) {
            $table->id();
            $table->bigInteger( 'supplier_code');
            $table->string( 'first_name' )->nullable();
            $table->string('second_name' )->nullable();
            $table->string( 'email' )->nullable();
            $table->string( 'phone_1' )->nullable();
            $table->string( 'phone_2' )->nullable();
            $table->text( 'address' )->nullable();
            $table->string( 'country' )->nullable();
            $table->string( 'city' )->nullable();
            $table->text( 'post_box' )->nullable();
            $table->string( 'company' )->nullable();
            $table->boolean('is_active')->default(1);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();

            $table->
            foreign("supplier_code")->
            references("code")->
            on("suppliers")->
            onDelete("cascade");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('supplier_addresses');
    }
}
