<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSuppliersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('suppliers', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->string('custom_code')->unique()->nullable();
            $table->bigInteger('stock_location_code')->nullable();
            $table->string('name')->nullable();
            $table->string('contact_name')->nullable();
            $table->string('address_1')->nullable();
            $table->string('address_2')->nullable();
            $table->string('currency')->nullable();
            $table->string('country')->nullable();
            $table->string('phone_1')->nullable();
            $table->string('phone_2')->nullable();
            $table->string('web_site')->nullable();
            $table->string('email')->nullable();
            $table->decimal('grn_total', 12, 2)->nullable();
            $table->decimal('received_amount', 12, 2)->nullable();
            $table->decimal('over_payment', 12, 2)->nullable();
            $table->decimal('debit_amount', 12, 2)->nullable();
            $table->decimal('return_amount', 12, 2)->nullable();
            $table->decimal('cheque_return_amount', 12, 2)->nullable();
            $table->boolean('is_active')->default(1);
            $table->boolean('is_verified')->default(0);
            $table->string('username')->nullable();
            $table->string('password')->nullable();
            $table->string('passport_number')->nullable();
            $table->string('nic_number')->nullable();
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamp('email_verified_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('suppliers');
    }
}
