<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateItemMastersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('item_masters', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->string('reference_code')->nullable();
            $table->string('barcode')->unique();
            $table->string('name')->nullable();
            $table->string('description', 40, 2)->nullable();
            $table->bigInteger('category_code')->nullable();
            $table->BigInteger('sub_category_code')->nullable();
            $table->bigInteger('unit_code')->nullable();
            $table->bigInteger('brand_code')->nullable();
            $table->bigInteger('color_code')->nullable();
            $table->bigInteger('size_code')->nullable();
            $table->bigInteger('bin_location_code')->nullable();
            $table->decimal('wholesale_price', 10, 2)->nullable();
            $table->decimal('retail_price', 10, 2)->nullable();
            $table->decimal('dealer_price', 10, 2)->nullable();
            $table->decimal('least_price', 10, 2)->nullable();
            $table->decimal('cost_price', 10, 2)->nullable();
            $table->decimal('discount_price', 10, 2)->nullable();
            $table->decimal('discount', 10, 2)->nullable();
            $table->decimal('min_stock', 10, 2)->nullable();
            $table->decimal('max_stock', 10, 2)->nullable();
            $table->string('model')->nullable();
            $table->integer('box-per-pieces')->default(1);
            $table->string('reorder_stock')->nullable();
            $table->boolean('is_active')->default(1);
            $table->boolean('is_service')->default(0);
            $table->string('expiry_notification_days')->nullable();
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();

            $table->timestamps();

            $table->index('barcode');
            $table->index('name');

            $table->foreign("category_code")->references("code")->on("item_categories")->onDelete("cascade");

            $table->foreign("sub_category_code")->references("code")->on("item_sub_categories")->onDelete("cascade");

            $table->foreign("unit_code")->references("code")->on("item_units")->onDelete("cascade");

            $table->foreign("brand_code")->references("code")->on("item_brands")->onDelete("cascade");

            $table->foreign("color_code")->references("code")->on("item_colors")->onDelete("cascade");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('item_masters');

    }
}