<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTypeCustomersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('type_customers', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('customer_code');
            $table->bigInteger('type_code');
            $table->boolean('is_active')->default(1);
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();



            //many to many Relationship
            $table->
            foreign("customer_code")->
            references("code")->
            on("customers")->
            onDelete("cascade");

            //many to many Relationship
            $table->
            foreign("type_code")->
            references("code")->
            on("customer_types")->
            onDelete("cascade");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('type_customers');
    }
}
