<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCustomersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customers', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('code')->unique();
            $table->string('custom_code')->unique()->nullable();
            $table->bigInteger('stock_location_code')->nullable();
           // $table->bigInteger('rep_code')->nullable();
            $table->bigInteger('route_code')->nullable();
            $table->bigInteger('customer_type_code')->nullable();
            $table->string('company_name')->nullable();
            $table->string('title')->nullable();
            $table->string('first_name')->nullable();
            $table->string('second_name')->nullable();
            $table->string('phone_1')->nullable();
            $table->string('phone_2')->nullable();
            $table->string('email')->nullable();
            $table->string('website')->nullable();
            $table->decimal('credit_limit', 10, 2)->nullable();
            $table->decimal('invoice_total', 10, 2)->nullable();
            $table->decimal('received_amount', 10, 2)->nullable();
            $table->decimal('over_payment', 10, 2)->nullable();
            $table->decimal('credit_amount', 10, 2)->nullable();
            $table->decimal('return_amount', 18, 2)->nullable();
            $table->decimal('cheque_return_amount', 10, 2)->nullable();
            $table->bigInteger('credit_days')->nullable();
            $table->string('username')->nullable()->unique();
            $table->string('password')->nullable();
            $table->boolean('is_active')->default(1)->nullable();
            $table->boolean('is_verified')->default(0)->nullable();
            $table->string('passport_number')->nullable()->unique();
            $table->string('nic_number')->nullable()->unique();
            $table->tinyInteger('rating')->nullable();
            $table->text('notes')->nullable();
            $table->string('fax')->nullable();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();

            //$table->foreign("rep_code")->references("code")->on("sales_reps")-> onDelete("cascade");
            $table->foreign("route_code")->references("code")->on("routes")-> onDelete("cascade");

            $table->foreign("customer_type_code")->references("code")->on("customer_types")-> onDelete("cascade");


        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customers');
    }
}
