<?php

namespace App\Models\Vehicle_Models;


use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;
use App\Models\Customer_Models\Customer;
use App\Models\Invoice_Models\Invoice;
use App\Models\Invoice_Models\InvoiceExt;

class VehicleMaster extends Model implements AuditableContract
{
    use HasFactory, Auditable;
    public $timestamps = false;
    protected $guarded = [];

    
    public function vehicleBrand()
    {
        return $this->belongsTo(VehicleBrand::class, 'brand_code', 'code');
    }

    public function vehicleType()
    {
        return $this->belongsTo(VehicleType::class, 'type_code', 'code');
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customer_code', 'code');
    }

    public function invoices()
    {
        return $this->hasMany(Invoice::class, 'vehicle_master_code', 'code');
    }

    public function invoiceExts()
    {
        return $this->hasMany(InvoiceExt::class, 'vehicle_master_code', 'code');
    }
}
