<?php

namespace App\Models\Vehicle_Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class VehicleBrand extends Model implements AuditableContract
{
    use HasFactory;
    public $timestamps=false;
    protected $guarded = [];
    use Auditable;


    public function vehicleMasters()
    {
        return $this->hasMany(VehicleMaster::class, 'brand_code','code');
    }
}
