<?php

namespace App\Models\Vehicle_Models;

use App\Models\Item_Models\ItemMaster;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Models\Vehicle_Models\ServicePackage;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class ServicePackageData extends Model implements AuditableContract
{
    use HasFactory, Auditable;
    public $timestamps=false;
    protected $guarded = [];

  
    public function itemMaster()
    {
        return $this->belongsTo(ItemMaster::class,'item_code','code');
    }
    
    public function servicePackage()
    {
        return $this->belongsTo(ServicePackage::class,'service_package_code','code');
    }
}
