<?php

namespace App\Models\Vehicle_Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Invoice_Models\Invoice;
use App\Models\Vehicle_Models\ServicePackageData;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class ServicePackage extends Model implements AuditableContract
{
    use HasFactory, Auditable;
    public $timestamps=false;
    protected $guarded = [];


    public function servicePackageDatas()
    {
        return $this->hasMany(ServicePackageData::class,'service_package_code','code');
    }

    public function invoice()
    {
       return $this->belongsToMany(invoice::class,'invoice_service_packages','service_package_code','invoice_code');
    }
}
