<?php

namespace App\Models\Vehicle_Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Invoice_Models\Invoice;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;

class InvoiceServicePackage extends Model  implements AuditableContract
{
    use HasFactory, Auditable;
    public $timestamps=false;
    protected $guarded = [];

    public function invoice()
    {
        return $this->belongsTo(Invoice::class,'invoice_code','code');
    }
}
