<?php

namespace App\Models;

use App\Models\CustomerChequeReturnPayment_Models\CusCheqReturnReceipt;
use App\Models\Expense_Models\Expense;
use App\Models\Invoice_Models\Invoice;
use App\Models\PaymentReceipt_Models\PaymentReceipt;
use App\Models\PaymentVoucher_Models\PaymentVoucher;
use App\Models\Stock_Models\Route;
use App\Models\Stock_Models\StockLocation;
use App\Models\System_Models\StockLocationUserRole;
use App\Models\System_Models\SystemPage;
use App\Models\System_Models\SystemPagesUser;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use OwenIt\Auditing\Auditable;
use OwenIt\Auditing\Contracts\Auditable as AuditableContract;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable implements AuditableContract
{

    use HasFactory, HasApiTokens, Notifiable;
    use Auditable;
    public $timestamps = false;
    protected $guarded = [];


    protected $hidden = [
        'password',
    ];


    public function role()
    {
        return $this->hasOne(UserRole::class);
    }
    /**
     * The stockLocations that belong to the User
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function stockLocations(): BelongsToMany
    {
        return $this->belongsToMany(StockLocation::class, 'stock_location_user_roles', 'user_id', 'stock_location_code', 'id', 'code')
            ->withPivot('role_id', 'series');
    }

    public function paymentReceipts()
    {
        return $this->hasMany(PaymentReceipt::class, 'created_by', 'id');
    }

    public function paymentVouchers()
    {
        return $this->hasMany(PaymentVoucher::class, 'created_by', 'id');
    }

    public function expenses()
    {
        return $this->hasMany(Expense::class, 'created_by', 'id');
    }

    public function cusCheqRtrnsReceipts()
    {
        return $this->hasMany(CusCheqReturnReceipt::class, 'created_by', 'id');
    }

    public function invoices()
    {
        return $this->hasMany(Invoice::class, 'created_by', 'id');
    }

    public function routes()
    {
        return $this->hasMany(Route::class,'rep_code','code');
    }
    public function stockLocationUserRole()
    {
        return $this->hasMany(StockLocationUserRole::class,'rep_code','code');
    }
    
}
